/**
 * Copyright Notice
 *
 * This is a work of the U.S. Government and is not subject to copyright
 * protection in the United States. Foreign copyrights may apply.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package gov.va.med.term.mvx.data;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import gov.vha.isaac.ochre.api.State;

/**
 * 
 * {@link MVXCodesHelper}
 *
 * @author <a href="mailto:joel.kniaz.list@gmail.com">Joel Kniaz</a>
 *
 */
public class MVXCodesHelper {
	private MVXCodesHelper() {}

	/**
	 * Gets the value of the mvxCode property.
	 * 
	 * @return
	 *     possible object is
	 *     {@link String }
	 *     
	 */
	public static String getMvxCode(MVXCodes.MVXInfo info) {
		return info.mvxCode != null ? info.mvxCode.trim() : null;
	}

	/**
	 * Gets the value of the manufacturerName property.
	 * 
	 * @return
	 *     possible object is
	 *     {@link String }
	 *     
	 */
	public static String getManufacturerName(MVXCodes.MVXInfo info) {
		return info.manufacturerName != null ? info.manufacturerName.trim() : null;
	}

	/**
	 * Gets the value of the notes property.
	 * 
	 * @return
	 *     possible object is
	 *     {@link String }
	 *     
	 */
	public static String getNotes(MVXCodes.MVXInfo info) {
		return info.getNotes() != null ? info.getNotes().trim() : null;
	}

	/**
	 * Gets the value of the status property.
	 * 
	 * @return
	 *     possible object is
	 *     {@link String }
	 *     
	 */
	public static State getState(MVXCodes.MVXInfo info) {
		return State.valueOf(info.getStatus().toUpperCase());
	}

	/**
	 * Gets the value of the lastUpdated property.
	 * 
	 * @return
	 *     possible object is
	 *     {@link String }
	 *     
	 */
	public static Date getLastUpdatedDate(MVXCodes.MVXInfo info) throws ParseException {
		DateFormat df = new SimpleDateFormat("MM/dd/yyyy");
		return df.parse(info.getLastUpdated()); 
	}
}
